/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public class StartPhase
extends Phase {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    public static final TargetingConditions AGRO_TARGETS = TargetingConditions.m_148352_().m_148355_().m_26883_(300.0).m_26888_(e -> e instanceof Player);
    private Path currentPath;
    private Vec3 targetLocation;
    private boolean clockwise;
    private float agroLevel = 0.0f;
    private float minAgroLevel = 100.0f;
    private float maxAgroLevel = 300.0f;
    private float targetAgroLevel = 0.0f;
    private int agroModifier = 0;
    private int maxAgroModifier = 2400;
    private int failedAttacks = 0;

    public StartPhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    public PhaseType<StartPhase> getType() {
        return PhaseType.START;
    }

    @Override
    public void serverTick() {
        double distanceFromTarget;
        this.agroLevel += (float)this.getPlayerCount();
        if (TimeKeeper.getServerTick() % 10 == 0) {
            this.debug("Start Phase, Target Agro: " + this.targetAgroLevel / 20.0f + ", Agro: " + this.agroLevel / 20.0f);
        }
        if (this.agroLevel >= this.targetAgroLevel / (float)Math.max(this.failedAttacks, 1) && this.startNextAttack()) {
            return;
        }
        double d = distanceFromTarget = this.targetLocation == null ? 0.0 : this.targetLocation.m_82531_(this.guardian.m_20185_(), this.guardian.m_20186_(), this.guardian.m_20189_());
        if (distanceFromTarget < 100.0 || distanceFromTarget > 22500.0 || this.guardian.f_19862_ || this.guardian.f_19863_) {
            this.resumePathing();
        }
    }

    @Override
    public void globalServerTick() {
        if (this.agroModifier > 0) {
            --this.agroModifier;
        }
    }

    @Override
    public void initPhase() {
        this.minAgroLevel = 200.0f;
        this.maxAgroLevel = 600.0f;
        if (this.agroModifier > this.maxAgroModifier) {
            this.agroModifier = this.maxAgroModifier;
        }
        this.currentPath = null;
        this.targetLocation = null;
        float agroMod = 1.0f - (float)this.agroModifier / (float)this.maxAgroModifier * 0.75f;
        float minAgro = this.minAgroLevel * agroMod;
        float maxAgro = this.maxAgroLevel * agroMod;
        this.targetAgroLevel = minAgro + this.random.m_188501_() * (maxAgro - minAgro);
        this.agroLevel = 0.0f;
        if (this.guardian.m_9236_().m_7654_() != null) {
            this.debug("Start Phase, Target Agro: " + this.targetAgroLevel / 20.0f + ", Agro: " + this.agroLevel / 20.0f);
        }
    }

    @Override
    @Nullable
    public Vec3 getTargetLocation() {
        return this.targetLocation;
    }

    private boolean startNextAttack() {
        Player closeTarget = this.guardian.m_9236_().m_45924_(this.guardian.m_20185_(), this.guardian.m_20186_(), this.guardian.m_20189_(), 30.0, true);
        if (closeTarget != null && (this.guardian.getShieldPower() < (float)DEConfig.guardianShield || this.random.m_188501_() < 0.25f)) {
            this.guardian.getPhaseManager().setPhase(PhaseType.COVER_FIRE);
            return true;
        }
        boolean aggressive = (double)this.agroModifier > (double)this.maxAgroModifier * 0.75 || this.failedAttacks > 3;
        SimpleWeightedRandomList<PhaseType<?>> phases = aggressive ? PhaseType.AGGRESSIVE_WEIGHTED : PhaseType.NORMAL_WEIGHTED;
        Vec3 focus = Vec3.m_82512_((Vec3i)this.guardian.getArenaOrigin());
        List<Player> targetOptions = this.guardian.m_9236_().m_6907_().stream().filter(e -> e.m_20238_(focus) <= 40000.0).filter(e -> AGRO_TARGETS.m_26885_((LivingEntity)this.guardian, (LivingEntity)e)).map(e -> e).toList();
        if (targetOptions.isEmpty()) {
            return false;
        }
        GuardianFightManager manager = this.guardian.getFightManager();
        if (manager == null) {
            return false;
        }
        PhaseType phaseType = (PhaseType)phases.m_216820_(this.random).get();
        Object phase = this.guardian.getPhaseManager().getPhase(phaseType);
        if (phase instanceof ChargeUpPhase) {
            this.failedAttacks = 0;
            this.guardian.getPhaseManager().setPhase(PhaseType.APPROACH_POSITION).setTargetLocation(Vec3.m_82512_((Vec3i)manager.getArenaOrigin().m_6630_(48))).setNextPhase(phaseType);
        } else {
            this.guardian.getPhaseManager().setPhase(phaseType).targetPlayer(targetOptions.get(this.random.m_188503_(targetOptions.size())));
        }
        return false;
    }

    private void resumePathing() {
        if (this.currentPath == null || this.currentPath.m_77392_()) {
            int nearestIndex;
            int endIndex = nearestIndex = this.guardian.initPathPoints(false);
            if (this.guardian.m_217043_().m_188503_(8) == 0) {
                boolean bl = this.clockwise = !this.clockwise;
            }
            endIndex = this.clockwise ? (endIndex += 5 + this.guardian.m_217043_().m_188503_(7)) : (endIndex -= 5 + this.guardian.m_217043_().m_188503_(7));
            endIndex = Math.floorMod(endIndex, 24);
            this.currentPath = this.guardian.findPath(nearestIndex, endIndex, null);
            if (this.currentPath != null) {
                this.currentPath.m_77374_();
            }
        }
        this.navigateToNextPathNode();
    }

    public void immediateAttack(@Nullable Player target) {
        if (target != null) {
            this.attackPlayer(target);
        } else {
            this.agroLevel = this.targetAgroLevel;
        }
    }

    private void attackPlayer(Player player) {
        if (this.guardian.m_217043_().m_188501_() > 0.5f && this.guardian.m_20280_((Entity)player) >= 40.0) {
            this.guardian.getPhaseManager().setPhase(PhaseType.BOMBARD_PLAYER).targetPlayer(player);
        } else {
            this.guardian.getPhaseManager().setPhase(PhaseType.CHARGE_PLAYER).targetPlayer(player);
        }
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.m_77392_()) {
            BlockPos nextPos = this.currentPath.m_77400_();
            this.currentPath.m_77374_();
            double x = nextPos.m_123341_();
            double z = nextPos.m_123343_();
            double y = (float)nextPos.m_123342_() + this.guardian.m_217043_().m_188501_() * 20.0f;
            this.targetLocation = new Vec3(x, y, z);
        }
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        if (!effective) {
            this.agroLevel += this.targetAgroLevel * 0.5f * (damage / 50.0f);
        }
        this.agroLevel = shield - damage > 0.0f ? (this.agroLevel += this.targetAgroLevel * 0.5f * (damage / ((float)DEConfig.guardianShield / 10.0f))) : (this.agroLevel += this.targetAgroLevel * 0.5f * (damage / ((float)DEConfig.guardianHealth / 10.0f)));
        this.agroModifier = (int)((float)this.agroModifier + (float)this.maxAgroModifier * 0.1f);
        if (this.guardian.m_9236_().m_7654_() != null) {
            this.debug("Agro: " + this.agroLevel + ", Agro Target: " + this.targetAgroLevel + ", Modifier: " + this.agroModifier + " " + (float)this.agroModifier / (float)this.maxAgroModifier * 100.0f + "%");
        }
        return damage;
    }

    @Override
    public void onCrystalAttacked(GuardianCrystalEntity crystal, BlockPos pos, DamageSource dmgSrc, @Nullable Player plyr, float damage, boolean destroyed) {
        if (destroyed) {
            if (plyr != null && !plyr.m_150110_().f_35934_) {
                this.attackPlayer(plyr);
            } else {
                this.agroLevel = this.targetAgroLevel;
            }
        } else {
            this.agroLevel += this.targetAgroLevel * 0.25f * (damage / 10.0f);
            this.agroModifier = (int)((float)this.agroModifier + (float)this.maxAgroModifier * 0.05f * (damage / 10.0f));
            if (this.guardian.m_9236_().m_7654_() != null) {
                this.debug("Agro: " + this.agroLevel + ", Agro Target: " + this.targetAgroLevel + ", Modifier: " + this.agroModifier + " " + (float)this.agroModifier / (float)this.maxAgroModifier * 100.0f + "%");
            }
        }
    }

    private int getPlayerCount() {
        GuardianFightManager manager = this.guardian.getFightManager();
        if (manager != null) {
            return manager.getTrackedPlayers().size();
        }
        return this.guardian.m_9236_().m_45955_(AGRO_TARGETS, (LivingEntity)this.guardian, this.guardian.m_20191_().m_82400_(244.0)).size();
    }

    public StartPhase prevAttackFailed() {
        ++this.failedAttacks;
        return this;
    }
}

